#include "check_http_hook_retries_node.h"

namespace NInfra::NPodAgent {

ENodeType TCheckHttpHookRetriesNode::GetType() const {
    return TCheckHttpHookRetriesNode::NODE_TYPE;
}

TTickResult TCheckHttpHookRetriesNode::TickImpl(TTickContextPtr) {
    if (MaxTries_ == 0) {
        return TNodeError{"Check http hook retries node must be unreachable when MaxTries is zero"};
    }

    ui32 tries =
        WorkloadStatusRepository_->GetHttpRequestsSuccessCounter(WorkloadId_, NetworkHookType_)
        + WorkloadStatusRepository_->GetHttpRequestsErrorCounter(WorkloadId_, NetworkHookType_)
        + WorkloadStatusRepository_->GetHttpRequestsTimeoutCounter(WorkloadId_, NetworkHookType_)
        + WorkloadStatusRepository_->GetHttpRequestsWrongAnswerCounter(WorkloadId_, NetworkHookType_);

    if (tries < MaxTries_) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "Workload '" << WorkloadId_ << "' exceeded " << NetworkHookType_ << " tries limit: " << MaxTries_);
    }
}

} // namespace NInfra::NPodAgent
