#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

namespace NInfra::NPodAgent {

class TCheckHttpHookRetriesNode;
using TCheckHttpHookRetriesNodePtr = TSimpleSharedPtr<TCheckHttpHookRetriesNode>;

class TCheckHttpHookRetriesNode : public TWorkloadBasicNode  {
public:
    TCheckHttpHookRetriesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , ui32 maxTries
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , NetworkHookType_(networkHookType)
        , MaxTries_(maxTries)
    {
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CHECK_HTTP_HOOK_RETRIES;

private:
    const NStatusRepositoryTypes::ENetworkHookType NetworkHookType_;
    const ui32 MaxTries_;
};

} // namespace NInfra::NPodAgent
