#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackHttpHookFailReasonNode;
using TFeedbackHttpHookFailReasonNodePtr = TSimpleSharedPtr<TFeedbackHttpHookFailReasonNode>;

class TFeedbackHttpHookFailReasonNode : public TWorkloadBasicNode {
public:
    TFeedbackHttpHookFailReasonNode(
        const TBasicTreeNodeDescriptor& descriptor
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& failReason
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , NetworkHookType_(networkHookType)
        , FailReason_(failReason)
    {
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_HTTP_HOOK_FAIL_REASON;

private:
    const NStatusRepositoryTypes::ENetworkHookType NetworkHookType_;
    const TString FailReason_;
};

} // namespace NInfra::NPodAgent
