#include "feedback_http_hook_fail_reason_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/test_functions.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestFeedbackHttpHookFailReasonNode {

Y_UNIT_TEST_SUITE(FeedbackHttpHookFailReasonNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestUpdateFailReason) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    const TString id = "my_workload";
    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(id));
    const TString failReason = "fail reason";
    auto test = [&](NStatusRepositoryTypes::ENetworkHookType networkHookType) {
        TFeedbackHttpHookFailReasonNodePtr node = new TFeedbackHttpHookFailReasonNode(TBasicTreeNodeDescriptor{1, "title"}, id, networkHookType, holder, failReason);

        auto result = node->Tick(MockTickContext(logger));
        UNIT_ASSERT_C(result, result.Error().Message);
        UNIT_ASSERT_EQUAL(TNodeSuccess(ENodeStatus::SUCCESS), result.Success());

        auto status = GetHttpHookStatus(holder->GetObjectStatus(id), networkHookType);
        UNIT_ASSERT_EQUAL(failReason, status.current().fail_reason());
    };

    TestHttpHookAllTypes(test);
}

Y_UNIT_TEST(TestWithUndefinedWorkloadStatusRepository) {
    auto test = [&](NStatusRepositoryTypes::ENetworkHookType networkHookType) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TFeedbackHttpHookFailReasonNode(
                TBasicTreeNodeDescriptor{1, "title"}
                , "my_workload"
                , networkHookType
                , nullptr
                , "fail reason"
            )
            , yexception
            , "WorkloadStatusRepository not defined"
        );
    };

    TestHttpHookAllTypes(test);
}

}

} // namespace NInfra::NPodAgent::NTestFeedbackHttpHookFailReasonNode
