#include "feedback_network_hook_state_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackNetworkHookStateNode::GetType() const {
    return TFeedbackNetworkHookStateNode::NODE_TYPE;
}

TTickResult TFeedbackNetworkHookStateNode::TickImpl(TTickContextPtr /*context*/) {
    switch (HookBackend_) {
        case NStatusRepositoryTypes::EHookBackend::HTTP:
            WorkloadStatusRepository_->UpdateHttpHookState(WorkloadId_, std::get<API::EHttpGetState>(State_), NetworkHookType_);
            break;
        case NStatusRepositoryTypes::EHookBackend::TCP:
            WorkloadStatusRepository_->UpdateTcpCheckState(WorkloadId_, std::get<API::ETcpCheckState>(State_), NetworkHookType_);
            break;
        case NStatusRepositoryTypes::EHookBackend::CONTAINER:
        case NStatusRepositoryTypes::EHookBackend::UNIX_SIGNAL:
        case NStatusRepositoryTypes::EHookBackend::NO_HOOK:
            ythrow yexception() << ToString(HookBackend_) << " shouldn't be provided";
            break;
    }
    return TNodeSuccess(ENodeStatus::SUCCESS);
}

} // namespace NInfra::NPodAgent
