#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

namespace NInfra::NPodAgent {

class TFeedbackNetworkHookStateNode;
using TFeedbackNetworkHookStateNodePtr = TSimpleSharedPtr<TFeedbackNetworkHookStateNode>;

class TFeedbackNetworkHookStateNode : public TWorkloadBasicNode {
public:
    using TNetworkHookState = std::variant<API::ETcpCheckState, API::EHttpGetState>;

public:
    TFeedbackNetworkHookStateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType checkType
        , NStatusRepositoryTypes::EHookBackend hookBackend
        , const TNetworkHookState& state
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , NetworkHookType_(checkType)
        , HookBackend_(hookBackend)
        , State_(state)
    {
        switch (HookBackend_) {
            case NStatusRepositoryTypes::EHookBackend::TCP:
                Y_ENSURE(std::holds_alternative<API::ETcpCheckState>(state), "expected ETcpCheckState");
                break;
            case NStatusRepositoryTypes::EHookBackend::HTTP:
                Y_ENSURE(std::holds_alternative<API::EHttpGetState>(state), "expected EHttpGetState");
                break;
            case NStatusRepositoryTypes::EHookBackend::CONTAINER:
            case NStatusRepositoryTypes::EHookBackend::UNIX_SIGNAL:
            case NStatusRepositoryTypes::EHookBackend::NO_HOOK:
                ythrow yexception() << ToString(HookBackend_) << " shouldn't be provided";
        }
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FEEDBACK_NETWORK_HOOK_STATE;

private:
    const NStatusRepositoryTypes::ENetworkHookType NetworkHookType_;
    const NStatusRepositoryTypes::EHookBackend HookBackend_;
    const TNetworkHookState State_;
};

} // namespace NInfra::NPodAgent
