#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/network_basic_node.h>

namespace NInfra::NPodAgent {

class TNetworkCheckAndAddRequestNode;
using TNetworkCheckAndAddRequestNodePtr = TSimpleSharedPtr<TNetworkCheckAndAddRequestNode>;

class TNetworkCheckAndAddRequestNode : public TNetworkBasicNode<TExpected<void, TNetworkClientError>> {
public:
    TNetworkCheckAndAddRequestNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , NStatusRepositoryTypes::EHookBackend hookBackend
        , const TString& requestHash
        , TNetworkClientPtr networkClient
        , const ui32 port
        , const TString& path
        , const TDuration& timeout
    )
        : TNetworkBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
            , networkHookType
            , requestHash
            , networkClient
        )
        , HookBackend_(hookBackend)
        , Port_(port)
        , Path_(path)
        , Timeout_(timeout)
    {
        switch (HookBackend_) {
            case NStatusRepositoryTypes::EHookBackend::TCP:
                Y_ENSURE(path.empty(), "expected empty path for tcp request");
                break;
            case NStatusRepositoryTypes::EHookBackend::HTTP:
                // pass
                break;
            case NStatusRepositoryTypes::EHookBackend::CONTAINER:
            case NStatusRepositoryTypes::EHookBackend::UNIX_SIGNAL:
            case NStatusRepositoryTypes::EHookBackend::NO_HOOK:
                ythrow yexception() << ToString(HookBackend_) << " shouldn't be provided";
        }
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<void, TNetworkClientError> NetworkClientCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessNetworkClientResult(TTickContextPtr context, TExpected<void, TNetworkClientError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::NETWORK_CHECK_AND_ADD_REQUEST;

private:
    const NStatusRepositoryTypes::EHookBackend HookBackend_;
    const ui32 Port_;
    const TString Path_;
    const TDuration Timeout_;
};

} // namespace NInfra::NPodAgent
