#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/network_basic_node.h>

namespace NInfra::NPodAgent {

class TNetworkGetAndRemoveRequestResponseNode;
using TNetworkGetAndRemoveRequestResponseNodePtr = TSimpleSharedPtr<TNetworkGetAndRemoveRequestResponseNode>;

class TNetworkGetAndRemoveRequestResponseNode : public TNetworkBasicNode<TExpected<TString, TNetworkClientError>> {
public:
    TNetworkGetAndRemoveRequestResponseNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , NStatusRepositoryTypes::EHookBackend hookBackend
        , const TString& requestHash
        , TNetworkClientPtr networkClient
        , const TString& expectedAnswer
        , bool anyAnswer
    )
        : TNetworkBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
            , networkHookType
            , requestHash
            , networkClient
        )
        , HookBackend_(hookBackend)
        , ExpectedAnswer_(expectedAnswer)
        , AnyAnswer_(anyAnswer)
    {
        switch (HookBackend_) {
            case NStatusRepositoryTypes::EHookBackend::TCP:
                Y_ENSURE(ExpectedAnswer_.empty(), "expected empty expectedAnswer for tcp request");
                Y_ENSURE(!AnyAnswer_, "expected anyAnswer==false for tcp request");
                break;
            case NStatusRepositoryTypes::EHookBackend::HTTP:
                Y_ENSURE(!(AnyAnswer_ && ExpectedAnswer_), "AnyAnswer and ExpectedAnswer provided simultaneously for http request");
                break;
            case NStatusRepositoryTypes::EHookBackend::CONTAINER:
            case NStatusRepositoryTypes::EHookBackend::UNIX_SIGNAL:
            case NStatusRepositoryTypes::EHookBackend::NO_HOOK:
                ythrow yexception() << ToString(HookBackend_) << " shouldn't be provided";
        }
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TString, TNetworkClientError> NetworkClientCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessNetworkClientResult(TTickContextPtr context, TExpected<TString, TNetworkClientError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::NETWORK_GET_AND_REMOVE_REQUEST_RESPONSE;

private:
    const NStatusRepositoryTypes::EHookBackend HookBackend_;
    const TString ExpectedAnswer_;
    const bool AnyAnswer_;
    TString RequestDescription_ = "";
};

} // namespace NInfra::NPodAgent
