#include "network_get_request_state_node.h"

namespace NInfra::NPodAgent {

ENodeType TNetworkGetRequestStateNode::GetType() const {
    return TNetworkGetRequestStateNode::NODE_TYPE;
}

TExpected<INetworkClient::ERequestState, TNetworkClientError> TNetworkGetRequestStateNode::NetworkClientCall(TTickContextPtr /*context*/) {
    return NetworkClient_->GetRequestState(GetRequestKey(), RequestHash_);
}

TTickResult TNetworkGetRequestStateNode::ProcessNetworkClientResult(TTickContextPtr /*context*/, TExpected<INetworkClient::ERequestState, TNetworkClientError>& result) {
    if (!result) {
        switch (HookBackend_) {
            case NStatusRepositoryTypes::EHookBackend::HTTP:
                WorkloadStatusRepository_->UpdateHttpHookState(WorkloadId_, API::EHttpGetState::EHttpGetState_UNKNOWN, NetworkHookType_);
                WorkloadStatusRepository_->UpdateHttpHookInnerFailReason(WorkloadId_, NetworkHookType_, MakeFullErrorMessage(result.Error().Message));
                break;
            case NStatusRepositoryTypes::EHookBackend::TCP:
                Y_ENSURE(NetworkHookType_ != NStatusRepositoryTypes::ENetworkHookType::STOP, "TCP NetworkHookType STOP is not supported");
                Y_ENSURE(NetworkHookType_ != NStatusRepositoryTypes::ENetworkHookType::DESTROY, "TCP NetworkHookType DESTROY is not supported");
                WorkloadStatusRepository_->UpdateTcpCheckState(WorkloadId_, API::ETcpCheckState::ETcpCheckState_UNKNOWN, NetworkHookType_);
                WorkloadStatusRepository_->UpdateTcpCheckFailReason(WorkloadId_, NetworkHookType_, MakeFullErrorMessage(result.Error().Message));
                break;
            case NStatusRepositoryTypes::EHookBackend::CONTAINER:
            case NStatusRepositoryTypes::EHookBackend::UNIX_SIGNAL:
            case NStatusRepositoryTypes::EHookBackend::NO_HOOK:
                ythrow yexception() << ToString(HookBackend_) << " shouldn't be provided";
        }
        return TNodeSuccess{
            ENodeStatus::FAILURE
            , ToString(result.Error())
        };
    }

    return TNodeSuccess(ENodeStatus::SUCCESS, ToString(result.Success()));
}

} // namespace NInfra::NPodAgent
