#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/network_basic_node.h>

namespace NInfra::NPodAgent {

class TNetworkGetRequestStateNode;
using TNetworkGetRequestStateNodePtr = TSimpleSharedPtr<TNetworkGetRequestStateNode>;

class TNetworkGetRequestStateNode : public TNetworkBasicNode<TExpected<INetworkClient::ERequestState, TNetworkClientError>> {
public:
    TNetworkGetRequestStateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , const TString& requestHash
        , TNetworkClientPtr networkClient
        , NStatusRepositoryTypes::EHookBackend hookBackend
    )
        : TNetworkBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
            , networkHookType
            , requestHash
            , networkClient
        )
        , HookBackend_(hookBackend)
    {
        Y_ENSURE(HookBackend_ != NStatusRepositoryTypes::EHookBackend::NO_HOOK, "NO_HOOK shouldn't be provided");
        Y_ENSURE(HookBackend_ != NStatusRepositoryTypes::EHookBackend::CONTAINER, "CONTAINER shouldn't be provided");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<INetworkClient::ERequestState, TNetworkClientError> NetworkClientCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessNetworkClientResult(TTickContextPtr context, TExpected<INetworkClient::ERequestState, TNetworkClientError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::NETWORK_GET_REQUEST_STATE;

private:
    const NStatusRepositoryTypes::EHookBackend HookBackend_;
};

} // namespace NInfra::NPodAgent
