#include "network_hook_consecutive_tries_reached_node.h"

namespace NInfra::NPodAgent {

ENodeType TNetworkHookConsecutiveTriesReachedNode::GetType() const {
    return TNetworkHookConsecutiveTriesReachedNode::NODE_TYPE;
}

TTickResult TNetworkHookConsecutiveTriesReachedNode::TickImpl(TTickContextPtr /*context*/) {
    ui32 consecutiveTries = 0;
    switch (HookBackend_) {
        case NStatusRepositoryTypes::EHookBackend::HTTP:
            consecutiveTries = CountSuccesses_
                ? WorkloadStatusRepository_->GetHttpHookConsecutiveSuccessesCounter(WorkloadId_, NetworkHookType_)
                : WorkloadStatusRepository_->GetHttpHookConsecutiveFailuresCounter(WorkloadId_, NetworkHookType_);
            break;
        case NStatusRepositoryTypes::EHookBackend::TCP:
            consecutiveTries = CountSuccesses_
                ? WorkloadStatusRepository_->GetTcpCheckConsecutiveSuccessesCounter(WorkloadId_, NetworkHookType_)
                : WorkloadStatusRepository_->GetTcpCheckConsecutiveFailuresCounter(WorkloadId_, NetworkHookType_);
            break;
        case NStatusRepositoryTypes::EHookBackend::CONTAINER:
        case NStatusRepositoryTypes::EHookBackend::UNIX_SIGNAL:
        case NStatusRepositoryTypes::EHookBackend::NO_HOOK:
            ythrow yexception() << ToString(HookBackend_) << " shouldn't be provided";
    }

    if (consecutiveTries >= TriesThreshold_) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << consecutiveTries << " not reached " << TriesThreshold_);
    }
}

} // namespace NInfra::NPodAgent
