#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>

namespace NInfra::NPodAgent {

class TNetworkHookConsecutiveTriesReachedNode;
using TNetworkHookConsecutiveTriesReachedNodePtr = TSimpleSharedPtr<TNetworkHookConsecutiveTriesReachedNode>;

class TNetworkHookConsecutiveTriesReachedNode : public TWorkloadBasicNode {
public:
    TNetworkHookConsecutiveTriesReachedNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , NStatusRepositoryTypes::EHookBackend hookBackend
        , bool countSuccesses
        , ui32 triesThreshold
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , NetworkHookType_(networkHookType)
        , HookBackend_(hookBackend)
        , CountSuccesses_(countSuccesses)
        , TriesThreshold_(triesThreshold)
    {
        Y_ENSURE(TriesThreshold_, "triesThreshold should not be zero");
        Y_ENSURE(HookBackend_ != NStatusRepositoryTypes::EHookBackend::NO_HOOK, "NO_HOOK shouldn't be provided");
        Y_ENSURE(HookBackend_ != NStatusRepositoryTypes::EHookBackend::CONTAINER, "CONTAINER shouldn't be provided");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::NETWORK_HOOK_CONSECUTIVE_TRIES_REACHED;

private:
    const NStatusRepositoryTypes::ENetworkHookType NetworkHookType_;
    const NStatusRepositoryTypes::EHookBackend HookBackend_;
    const bool CountSuccesses_;
    const ui32 TriesThreshold_;
};

} // namespace NInfra::NPodAgent
