#include "network_hook_start_time_expired_with_backoff_node.h"

namespace NInfra::NPodAgent {

ENodeType TNetworkHookStartTimeExpiredWithBackoffNode::GetType() const {
    return TNetworkHookStartTimeExpiredWithBackoffNode::NODE_TYPE;
}

TTickResult TNetworkHookStartTimeExpiredWithBackoffNode::TickImpl(TTickContextPtr context) {
    // step = Max(0, ConsecutiveFailuresCounter - 1) for workload stop and destroy
    // step = Max(0, ConsecutiveSuccessesCounter - 1) for all other checks
    ui32 consecutiveTries = 0;
    TInstant startTime;
    switch (HookBackend_) {
        case NStatusRepositoryTypes::EHookBackend::HTTP:
            startTime = WorkloadStatusRepository_->GetHttpHookStartTime(WorkloadId_, NetworkHookType_);
            consecutiveTries = (NetworkHookType_ == NStatusRepositoryTypes::ENetworkHookType::STOP || NetworkHookType_ == NStatusRepositoryTypes::ENetworkHookType::DESTROY)
                ? WorkloadStatusRepository_->GetHttpHookConsecutiveFailuresCounter(WorkloadId_, NetworkHookType_)
                : WorkloadStatusRepository_->GetHttpHookConsecutiveSuccessesCounter(WorkloadId_, NetworkHookType_);
            break;
        case NStatusRepositoryTypes::EHookBackend::TCP:
            Y_ENSURE(NetworkHookType_ != NStatusRepositoryTypes::ENetworkHookType::STOP, "TCP NetworkHookType STOP is not supported");
            Y_ENSURE(NetworkHookType_ != NStatusRepositoryTypes::ENetworkHookType::DESTROY, "TCP NetworkHookType DESTROY is not supported");
            startTime = WorkloadStatusRepository_->GetTcpCheckStartTime(WorkloadId_, NetworkHookType_);
            consecutiveTries = WorkloadStatusRepository_->GetTcpCheckConsecutiveSuccessesCounter(WorkloadId_, NetworkHookType_);
            break;
        case NStatusRepositoryTypes::EHookBackend::CONTAINER:
        case NStatusRepositoryTypes::EHookBackend::UNIX_SIGNAL:
        case NStatusRepositoryTypes::EHookBackend::NO_HOOK:
            ythrow yexception() << ToString(HookBackend_) << " shouldn't be provided";
    }
    ui32 step = Max((ui32)1, consecutiveTries) - 1;
    return BackoffCalcer_.CheckAndUpdateContext(startTime, step, context);
}

} // namespace NInfra::NPodAgent
