#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/workload_basic_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/time_expired_with_backoff_calcer.h>

namespace NInfra::NPodAgent {

class TNetworkHookStartTimeExpiredWithBackoffNode;
using TNetworkHookStartTimeExpiredWithBackoffNodePtr = TSimpleSharedPtr<TNetworkHookStartTimeExpiredWithBackoffNode>;

class TNetworkHookStartTimeExpiredWithBackoffNode : public TWorkloadBasicNode {
public:
    TNetworkHookStartTimeExpiredWithBackoffNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , NStatusRepositoryTypes::EHookBackend hookBackend
        , TDuration restartPeriodScale
        , ui64 restartPeriodBackOff
        , TDuration maxRestartPeriod
        , TDuration minRestartPeriod
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , NetworkHookType_(networkHookType)
        , HookBackend_(hookBackend)
        , BackoffCalcer_(
            restartPeriodScale
            , restartPeriodBackOff
            , maxRestartPeriod
            , minRestartPeriod
        )
    {
        Y_ENSURE(HookBackend_ != NStatusRepositoryTypes::EHookBackend::NO_HOOK, "NO_HOOK shouldn't be provided");
        Y_ENSURE(HookBackend_ != NStatusRepositoryTypes::EHookBackend::CONTAINER, "CONTAINER shouldn't be provided");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::NETWORK_HOOK_START_TIME_EXPIRED_WITH_BACKOFF;

private:
    const NStatusRepositoryTypes::ENetworkHookType NetworkHookType_;
    const NStatusRepositoryTypes::EHookBackend HookBackend_;
    const TTimeExpiredWithBackoffCalcer BackoffCalcer_;
};

} // namespace NInfra::NPodAgent
