#include "network_remove_request_node.h"

namespace NInfra::NPodAgent {

ENodeType TNetworkRemoveRequestNode::GetType() const {
    return TNetworkRemoveRequestNode::NODE_TYPE;
}

TExpected<void, TNetworkClientError> TNetworkRemoveRequestNode::NetworkClientCall(TTickContextPtr /*context*/) {
    return NetworkClient_->RemoveRequest(GetRequestKey());
}

TTickResult TNetworkRemoveRequestNode::ProcessNetworkClientResult(TTickContextPtr /*context*/, TExpected<void, TNetworkClientError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS, "Request removed");
    } else {
        if (result.Error().Errno == ENetworkClientError::RequestDoesNotExist) {
            return TNodeSuccess(ENodeStatus::SUCCESS, "Already removed");
        }

        return TNodeError{ToString(result.Error())};
    }
}

} // namespace NInfra::NPodAgent
