#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/network_basic_node.h>

namespace NInfra::NPodAgent {

class TNetworkRemoveRequestNode;
using TNetworkRemoveRequestNodePtr = TSimpleSharedPtr<TNetworkRemoveRequestNode>;

class TNetworkRemoveRequestNode : public TNetworkBasicNode<TExpected<void, TNetworkClientError>> {
public:
    TNetworkRemoveRequestNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , TNetworkClientPtr networkClient
    )
        : TNetworkBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
            , networkHookType
            // Hash is ignored when removing request
            , "" /* reqeustHash */
            , networkClient
        )
    {
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<void, TNetworkClientError> NetworkClientCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessNetworkClientResult(TTickContextPtr context, TExpected<void, TNetworkClientError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::NETWORK_REMOVE_REQUEST;
};

} // namespace NInfra::NPodAgent
