#include "porto_active_containers_limit_reached_node.h"

namespace NInfra::NPodAgent {

TTickResult TPortoActiveContainersLimitReachedNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>& result) {
    if (result) {
        ui32 activeContainers = 0;

        for (const auto& [containerId, containerProperties] : result.Success()) {
            if ((bool)PathHolder_->ExtractLayerHashFromContainer(containerId) || (bool)PathHolder_->ExtractStaticResourceHashFromContainer(containerId)) {
                EPortoContainerState state = FromString<EPortoContainerState>(containerProperties.at(EPortoContainerProperty::State).value());

                switch (state) {
                    case EPortoContainerState::Starting:
                    case EPortoContainerState::Running:
                    case EPortoContainerState::Paused:
                    case EPortoContainerState::Meta:
                    case EPortoContainerState::Stopping:
                    case EPortoContainerState::Respawning:
                        ++activeContainers;
                        break;
                    case EPortoContainerState::Stopped:
                    case EPortoContainerState::Dead:
                        break;
                }
            }
        }

        // ActiveContainersLimit may change for different calls
        // Save value for correct node status
        ui32 activeContainersLimit = GetActiveContainersLimit();

        if (activeContainers >= activeContainersLimit) {
            return TNodeSuccess(
                ENodeStatus::SUCCESS
                , TStringBuilder() << "Limit reached ("
                    << activeContainers << " of " << activeContainersLimit << ")"
            );
        } else {
            return TNodeSuccess(
                ENodeStatus::FAILURE
                , TStringBuilder() << "Limit not reached ("
                    << activeContainers << " of " << activeContainersLimit << ")"
            );
        }
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
