#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TPortoActiveContainersLimitReachedNode;
using TPortoActiveContainersLimitReachedNodePtr = TSimpleSharedPtr<TPortoActiveContainersLimitReachedNode>;

class TPortoActiveContainersLimitReachedNode : public TPortoBasicNode<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>> {
public:
    TPortoActiveContainersLimitReachedNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TPathHolderPtr pathHolder
        , TStatusRepositoryCommonPtr statusRepositoryCommon
    )
        : TPortoBasicNode(descriptor, porto)
        , PathHolder_(pathHolder)
        , StatusRepositoryCommon_(statusRepositoryCommon)
    {}

private:
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>& result) override final;
    virtual ui32 GetActiveContainersLimit() = 0;

protected:
    const TPathHolderPtr PathHolder_;
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
};

} // namespace NInfra::NPodAgent

