#include "porto_active_download_containers_limit_reached_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoActiveDownloadContainersLimitReachedNode::GetType() const {
    return TPortoActiveDownloadContainersLimitReachedNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> TPortoActiveDownloadContainersLimitReachedNode::PortoCall(TTickContextPtr /*context*/) {
    TVector<EPortoContainerProperty> properties{EPortoContainerProperty::State};
    return Porto_->Get({PathHolder_->GetDownloadContainerLookupMask()}, properties);
}

ui32 TPortoActiveDownloadContainersLimitReachedNode::GetActiveContainersLimit() {
    return StatusRepositoryCommon_->GetActiveDownloadContainersLimit();
}

} // namespace NInfra::NPodAgent
