#pragma once

#include "porto_active_containers_limit_reached_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TPortoActiveDownloadContainersLimitReachedNode;
using TPortoActiveDownloadContainersLimitReachedNodePtr = TSimpleSharedPtr<TPortoActiveDownloadContainersLimitReachedNode>;

class TPortoActiveDownloadContainersLimitReachedNode : public TPortoActiveContainersLimitReachedNode {
public:
    TPortoActiveDownloadContainersLimitReachedNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TPathHolderPtr pathHolder
        , TStatusRepositoryCommonPtr statusRepositoryCommon
    )
        : TPortoActiveContainersLimitReachedNode(descriptor, porto, pathHolder, statusRepositoryCommon)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual ui32 GetActiveContainersLimit() override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_ACTIVE_DOWNLOAD_CONTAINERS_LIMIT_REACHED;
};

} // namespace NInfra::NPodAgent

