#include "porto_active_download_containers_limit_reached_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/layer_status_repository.h>
#include <infra/pod_agent/libs/porto_client/mock_client.h>
#include <infra/pod_agent/libs/porto_client/test_functions.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NPortoTest::NTestPortoActiveDownloadContainersLimitReachedNode {

Y_UNIT_TEST_SUITE(PortoActiveDownloadContainersLimitReachedNodeSuite) {

static TLogger logger({});

TPortoActiveDownloadContainersLimitReachedNodePtr CreateNode(
    TPortoClientPtr porto
    , TPathHolderPtr pathHolder
    , TStatusRepositoryCommonPtr statusRepositoryCommon
) {
    return new TPortoActiveDownloadContainersLimitReachedNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , new TAsyncPortoClient(porto, new TFakeThreadPool())
        , pathHolder
        , statusRepositoryCommon
    );
}

Y_UNIT_TEST(TestAllCases) {
    struct TMyPortoClient : public TMockPortoClient {
        TMyPortoClient(
            TPathHolderPtr pathHolder
            , ui32 activeLayerDownloadContainers
            , ui32 nonActiveLayerDownloadContainers
            , ui32 activeStaticResourceDownloadContainers
            , ui32 nonActiveStaticResourceDownloadContainers
            , ui32 otherContainers
        )
            : PathHolder_(pathHolder)
            , ActiveLayerDownloadContainers_(activeLayerDownloadContainers)
            , NonActiveLayerDownloadContainers_(nonActiveLayerDownloadContainers)
            , ActiveStaticResourceDownloadContainers_(activeStaticResourceDownloadContainers)
            , NonActiveStaticResourceDownloadContainers_(nonActiveStaticResourceDownloadContainers)
            , OtherContainers_(otherContainers)
        {}

        TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError> Get(
            const TVector<TPortoContainerName>& names
            , const TVector<EPortoContainerProperty>& props
        ) override {
            ++GetCalls_;

            Names_ = names;
            Props_ = props;

            TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>> result;

            // Layer
            for (ui32 i = 0; i < ActiveLayerDownloadContainers_; ++i) {
                TPortoContainerName container = PathHolder_->GetLayerContainerWithNameFromHash("hash_active_" + ToString(i), "download");
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Running), 0, "");
            }
            for (ui32 i = 0; i < NonActiveLayerDownloadContainers_; ++i) {
                TPortoContainerName container = PathHolder_->GetLayerContainerWithNameFromHash("hash_non_active_" + ToString(i), "download");
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Dead), 0, "");
            }

            // Static resource
            for (ui32 i = 0; i < ActiveStaticResourceDownloadContainers_; ++i) {
                TPortoContainerName container = PathHolder_->GetStaticResourceContainerWithNameFromHash("hash_active_" + ToString(i), "download");
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Starting), 0, "");
            }
            for (ui32 i = 0; i < NonActiveStaticResourceDownloadContainers_; ++i) {
                TPortoContainerName container = PathHolder_->GetStaticResourceContainerWithNameFromHash("hash_non_active_" + ToString(i), "download");
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Stopped), 0, "");
            }

            // Other
            for (ui32 i = 0; i < NonActiveStaticResourceDownloadContainers_; ++i) {
                TPortoContainerName container = TPortoContainerName::NoEscape("other_container_" + ToString(i));
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Stopped), 0, "");
            }

            return result;
        }

        TPathHolderPtr PathHolder_;
        ui32 ActiveLayerDownloadContainers_;
        ui32 NonActiveLayerDownloadContainers_;
        ui32 ActiveStaticResourceDownloadContainers_;
        ui32 NonActiveStaticResourceDownloadContainers_;
        ui32 OtherContainers_;

        size_t GetCalls_ = 0;
        TVector<TPortoContainerName> Names_;
        TVector<EPortoContainerProperty> Props_;
    };

    auto test = [](
        ui32 activeLayerDownloadContainers
        , ui32 nonActiveLayerDownloadContainers
        , ui32 activeStaticResourceDownloadContainers
        , ui32 nonActiveStaticResourceDownloadContainers
        , ui32 otherContainers
        , ui32 activeDownloadContainersLimit
        , bool isSuccess
    ) {
        TPathHolderPtr pathHolder = new TPathHolder("", {{"", ""}}, {{"", ""}}, "", "", "", "", "", "");
        TPortoClientPtr porto = new TMyPortoClient(
            pathHolder
            , activeLayerDownloadContainers
            , nonActiveLayerDownloadContainers
            , activeStaticResourceDownloadContainers
            , nonActiveStaticResourceDownloadContainers
            , otherContainers
        );
        TLayerStatusRepositoryPtr statusRepository = new TLayerStatusRepository();
        statusRepository->UpdateActiveDownloadContainersLimit(activeDownloadContainersLimit);

        auto node = CreateNode(porto,  pathHolder, statusRepository);
        auto result = node->Tick(MockTickContext(logger));

        if (isSuccess) {
            UNIT_ASSERT_EQUAL_C(ENodeStatus::SUCCESS, result.Success().Status, result.Success().Message);
        } else {
            UNIT_ASSERT_EQUAL_C(ENodeStatus::FAILURE, result.Success().Status, result.Success().Message);
        }

        UNIT_ASSERT_EQUAL_C(1, ((TMyPortoClient*)porto.Get())->GetCalls_, ((TMyPortoClient*)porto.Get())->GetCalls_);
        UNIT_ASSERT_EQUAL(
            ((TMyPortoClient*)porto.Get())->Names_
            , TVector<TPortoContainerName>({pathHolder->GetDownloadContainerLookupMask()})
        );
        UNIT_ASSERT_EQUAL(
            ((TMyPortoClient*)porto.Get())->Props_
            , TVector<EPortoContainerProperty>({EPortoContainerProperty::State})
        );
    };

    for (ui32 nonActiveLayerDownloadContainers = 0; nonActiveLayerDownloadContainers < 2; ++nonActiveLayerDownloadContainers) {
        for (ui32 nonActiveStaticResourceDownloadContainers = 0; nonActiveStaticResourceDownloadContainers < 2; ++nonActiveStaticResourceDownloadContainers) {
            for (ui32 otherContainers = 0; otherContainers < 2; ++otherContainers) {
                test(
                    0
                    , nonActiveLayerDownloadContainers
                    , 0
                    , nonActiveStaticResourceDownloadContainers
                    , otherContainers
                    , 1
                    , false
                );
                test(
                    5
                    , nonActiveLayerDownloadContainers
                    , 6
                    , nonActiveStaticResourceDownloadContainers
                    , otherContainers
                    , 12
                    , false
                );
                test(
                    7
                    , nonActiveLayerDownloadContainers
                    , 5
                    , nonActiveStaticResourceDownloadContainers
                    , otherContainers
                    , 12
                    , true
                );
                test(
                    10
                    , nonActiveLayerDownloadContainers
                    , 11
                    , nonActiveStaticResourceDownloadContainers
                    , otherContainers
                    , 3
                    , true
                );
            }
        }
    }
}

}

} // namespace NInfra::NPodAgent::NPortoTest::NTestPortoActiveDownloadContainersLimitReachedNode
