#include "porto_active_verify_containers_limit_reached_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoActiveVerifyContainersLimitReachedNode::GetType() const {
    return TPortoActiveVerifyContainersLimitReachedNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> TPortoActiveVerifyContainersLimitReachedNode::PortoCall(TTickContextPtr /*context*/) {
    TVector<EPortoContainerProperty> properties{EPortoContainerProperty::State};
    return Porto_->Get({PathHolder_->GetVerifyContainerLookupMask()}, properties);
}

ui32 TPortoActiveVerifyContainersLimitReachedNode::GetActiveContainersLimit() {
    return StatusRepositoryCommon_->GetActiveVerifyContainersLimit();
}

} // namespace NInfra::NPodAgent
