#include "porto_active_verify_containers_limit_reached_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/layer_status_repository.h>
#include <infra/pod_agent/libs/porto_client/mock_client.h>
#include <infra/pod_agent/libs/porto_client/test_functions.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NPortoTest::NTestPortoActiveVerifyContainersLimitReachedNode {

Y_UNIT_TEST_SUITE(PortoActiveVerifyContainersLimitReachedNodeSuite) {

static TLogger logger({});

TPortoActiveVerifyContainersLimitReachedNodePtr CreateNode(
    TPortoClientPtr porto
    , TPathHolderPtr pathHolder
    , TStatusRepositoryCommonPtr statusRepositoryCommon
) {
    return new TPortoActiveVerifyContainersLimitReachedNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , new TAsyncPortoClient(porto, new TFakeThreadPool())
        , pathHolder
        , statusRepositoryCommon
    );
}

Y_UNIT_TEST(TestAllCases) {
    struct TMyPortoClient : public TMockPortoClient {
        TMyPortoClient(
            TPathHolderPtr pathHolder
            , ui32 activeLayerVerifyContainers
            , ui32 nonActiveLayerVerifyContainers
            , ui32 activeStaticResourceVerifyContainers
            , ui32 nonActiveStaticResourceVerifyContainers
            , ui32 otherContainers
        )
            : PathHolder_(pathHolder)
            , ActiveLayerVerifyContainers_(activeLayerVerifyContainers)
            , NonActiveLayerVerifyContainers_(nonActiveLayerVerifyContainers)
            , ActiveStaticResourceVerifyContainers_(activeStaticResourceVerifyContainers)
            , NonActiveStaticResourceVerifyContainers_(nonActiveStaticResourceVerifyContainers)
            , OtherContainers_(otherContainers)
        {}

        TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError> Get(
            const TVector<TPortoContainerName>& names
            , const TVector<EPortoContainerProperty>& props
        ) override {
            ++GetCalls_;

            Names_ = names;
            Props_ = props;

            TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>> result;

            // Layer
            for (ui32 i = 0; i < ActiveLayerVerifyContainers_; ++i) {
                TPortoContainerName container = PathHolder_->GetLayerContainerWithNameFromHash("hash_active_" + ToString(i), "verify");
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Running), 0, "");
            }
            for (ui32 i = 0; i < NonActiveLayerVerifyContainers_; ++i) {
                TPortoContainerName container = PathHolder_->GetLayerContainerWithNameFromHash("hash_non_active_" + ToString(i), "verify");
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Dead), 0, "");
            }

            // Static resource
            for (ui32 i = 0; i < ActiveStaticResourceVerifyContainers_; ++i) {
                TPortoContainerName container = PathHolder_->GetStaticResourceContainerWithNameFromHash("hash_active_" + ToString(i), "verify");
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Starting), 0, "");
            }
            for (ui32 i = 0; i < NonActiveStaticResourceVerifyContainers_; ++i) {
                TPortoContainerName container = PathHolder_->GetStaticResourceContainerWithNameFromHash("hash_non_active_" + ToString(i), "verify");
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Stopped), 0, "");
            }

            // Other
            for (ui32 i = 0; i < NonActiveStaticResourceVerifyContainers_; ++i) {
                TPortoContainerName container = TPortoContainerName::NoEscape("other_container_" + ToString(i));
                result[container] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[container][EPortoContainerProperty::State] = CreateTPortoGetResponse(ToString(EPortoContainerState::Stopped), 0, "");
            }

            return result;
        }

        TPathHolderPtr PathHolder_;
        ui32 ActiveLayerVerifyContainers_;
        ui32 NonActiveLayerVerifyContainers_;
        ui32 ActiveStaticResourceVerifyContainers_;
        ui32 NonActiveStaticResourceVerifyContainers_;
        ui32 OtherContainers_;

        size_t GetCalls_ = 0;
        TVector<TPortoContainerName> Names_;
        TVector<EPortoContainerProperty> Props_;
    };

    auto test = [](
        ui32 activeLayerVerifyContainers
        , ui32 nonActiveLayerVerifyContainers
        , ui32 activeStaticResourceVerifyContainers
        , ui32 nonActiveStaticResourceVerifyContainers
        , ui32 otherContainers
        , ui32 activeVerifyContainersLimit
        , bool isSuccess
    ) {
        TPathHolderPtr pathHolder = new TPathHolder("", {{"", ""}}, {{"", ""}}, "", "", "", "", "", "");
        TPortoClientPtr porto = new TMyPortoClient(
            pathHolder
            , activeLayerVerifyContainers
            , nonActiveLayerVerifyContainers
            , activeStaticResourceVerifyContainers
            , nonActiveStaticResourceVerifyContainers
            , otherContainers
        );
        TLayerStatusRepositoryPtr statusRepository = new TLayerStatusRepository();
        statusRepository->UpdateActiveVerifyContainersLimit(activeVerifyContainersLimit);

        auto node = CreateNode(porto,  pathHolder, statusRepository);
        auto result = node->Tick(MockTickContext(logger));

        if (isSuccess) {
            UNIT_ASSERT_EQUAL_C(ENodeStatus::SUCCESS, result.Success().Status, result.Success().Message);
        } else {
            UNIT_ASSERT_EQUAL_C(ENodeStatus::FAILURE, result.Success().Status, result.Success().Message);
        }

        UNIT_ASSERT_EQUAL_C(1, ((TMyPortoClient*)porto.Get())->GetCalls_, ((TMyPortoClient*)porto.Get())->GetCalls_);
        UNIT_ASSERT_EQUAL(
            ((TMyPortoClient*)porto.Get())->Names_
            , TVector<TPortoContainerName>({pathHolder->GetVerifyContainerLookupMask()})
        );
        UNIT_ASSERT_EQUAL(
            ((TMyPortoClient*)porto.Get())->Props_
            , TVector<EPortoContainerProperty>({EPortoContainerProperty::State})
        );
    };

    for (ui32 nonActiveLayerVerifyContainers = 0; nonActiveLayerVerifyContainers < 2; ++nonActiveLayerVerifyContainers) {
        for (ui32 nonActiveStaticResourceVerifyContainers = 0; nonActiveStaticResourceVerifyContainers < 2; ++nonActiveStaticResourceVerifyContainers) {
            for (ui32 otherContainers = 0; otherContainers < 2; ++otherContainers) {
                test(
                    0
                    , nonActiveLayerVerifyContainers
                    , 0
                    , nonActiveStaticResourceVerifyContainers
                    , otherContainers
                    , 1
                    , false
                );
                test(
                    5
                    , nonActiveLayerVerifyContainers
                    , 6
                    , nonActiveStaticResourceVerifyContainers
                    , otherContainers
                    , 12
                    , false
                );
                test(
                    7
                    , nonActiveLayerVerifyContainers
                    , 5
                    , nonActiveStaticResourceVerifyContainers
                    , otherContainers
                    , 12
                    , true
                );
                test(
                    10
                    , nonActiveLayerVerifyContainers
                    , 11
                    , nonActiveStaticResourceVerifyContainers
                    , otherContainers
                    , 3
                    , true
                );
            }
        }
    }
}

}

} // namespace NInfra::NPodAgent::NPortoTest::NTestPortoActiveVerifyContainersLimitReachedNode
