#include "porto_add_properties_to_container_fail_reason_node.h"
#include "porto_utils.h"

namespace NInfra::NPodAgent {

ENodeType TPortoAddPropertiesToContainerFailReasonNode::GetType() const {
    return TPortoAddPropertiesToContainerFailReasonNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> TPortoAddPropertiesToContainerFailReasonNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->Get({ContainerName_}, Properties_);
}

TTickResult TPortoAddPropertiesToContainerFailReasonNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>& result) {
    if (result) {
        if (!result.Success().contains(ContainerName_)) {
            return TNodeError({TStringBuilder() << "porto get call doesn't contain '" << TString(ContainerName_) << "' container"});
        }

        const TMap<EPortoContainerProperty, TPortoGetResponse>& propertiesMap = result.Success()[ContainerName_];

        TString failReason = ContainerStatusRepository_->GetContainerFailReason(Container_);

        failReason += OUTCOME_TRYX(PropertiesToString(ContainerName_, Properties_, propertiesMap, ", "));

        ContainerStatusRepository_->UpdateContainerFailReason(Container_, failReason);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
