#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TPortoAddPropertiesToContainerFailReasonNode;
using TPortoAddPropertiesToContainerFailReasonNodePtr = TSimpleSharedPtr<TPortoAddPropertiesToContainerFailReasonNode>;

class TPortoAddPropertiesToContainerFailReasonNode : public TPortoBasicNode<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>> {
public:
    TPortoAddPropertiesToContainerFailReasonNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TPortoContainerName& containerName
        , TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TVector<EPortoContainerProperty>& properties
    )
        : TPortoBasicNode(descriptor, porto)
        , ContainerName_(containerName)
        , ContainerStatusRepository_(containerStatusRepository)
        , Container_(container)
        , Properties_(properties)
    {
        Y_ENSURE(ContainerStatusRepository_, "ContainerStatusRepository not defined for TPortoAddPropertiesToContainerFailReasonNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_ADD_PROPERTIES_TO_CONTAINER_FAIL_REASON;

private:
    const TPortoContainerName ContainerName_;
    const TStatusRepositoryCommonPtr ContainerStatusRepository_;
    const NStatusRepositoryTypes::TContainerDescription Container_;
    const TVector<EPortoContainerProperty> Properties_;
};

} // namespace NInfra::NPodAgent
