#include "porto_add_properties_to_object_failed_message_node.h"
#include "porto_utils.h"

namespace NInfra::NPodAgent {

ENodeType TPortoAddPropertiesToObjectFailedMessageNode::GetType() const {
    return TPortoAddPropertiesToObjectFailedMessageNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> TPortoAddPropertiesToObjectFailedMessageNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->Get({ContainerName_}, Properties_);
}

TTickResult TPortoAddPropertiesToObjectFailedMessageNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>& result) {
    if (result) {
        if (!result.Success().contains(ContainerName_)) {
            return TNodeError({TStringBuilder() << "porto get call doesn't contain '" << TString(ContainerName_) << "' container"});
        }

        const TMap<EPortoContainerProperty, TPortoGetResponse>& propertiesMap = result.Success()[ContainerName_];
        TString failedMessage = OUTCOME_TRYX(PropertiesToString(ContainerName_, Properties_, propertiesMap, "\n"));

        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, failedMessage);
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
