#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TPortoAddPropertiesToObjectFailedMessageNode;
using TPortoAddPropertiesToObjectFailedMessageNodePtr = TSimpleSharedPtr<TPortoAddPropertiesToObjectFailedMessageNode>;

class TPortoAddPropertiesToObjectFailedMessageNode : public TPortoBasicNode<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>> {
public:
    TPortoAddPropertiesToObjectFailedMessageNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TPortoContainerName& containerName
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
        , const TVector<EPortoContainerProperty>& properties
    )
        : TPortoBasicNode(descriptor, porto)
        , ContainerName_(containerName)
        , StatusRepositoryCommon_(statusRepositoryCommon)
        , ObjectIdOrHash_(objectIdOrHash)
        , Properties_(properties)
    {
        Y_ENSURE(StatusRepositoryCommon_, "StatusRepositoryCommon not defined for TPortoAddPropertiesToObjectFailedMessageNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_ADD_PROPERTIES_TO_OBJECT_FAILED_MESSAGE;

private:
    const TPortoContainerName ContainerName_;
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
    const TString ObjectIdOrHash_;
    const TVector<EPortoContainerProperty> Properties_;
};

} // namespace NInfra::NPodAgent
