#include "porto_clean_linked_volumes_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoCleanLinkedVolumesNode::GetType() const {
    return TPortoCleanLinkedVolumesNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TVector<TString>, TPortoError>>, TTickResult> TPortoCleanLinkedVolumesNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->ListVolumesPaths();
}

TTickResult TPortoCleanLinkedVolumesNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TVector<TString>, TPortoError>& result) {
    if (result) {
        for (const auto& volume : result.Success()) {
            if (volume.StartsWith(Path_)) {
                // we need to unlink every volume, so we don't check the hashes
                // we don't need to wait till the volume is unlinked, so we just return success
                auto unlinkResultFuture = Porto_->UnlinkVolume(volume, Container_, volume, false);

                // TODO(DEPLOY-1853, PORTO-644) fix this after fix in porto
                auto unlinkResult = unlinkResultFuture.GetValueSync();
                if (!unlinkResult && unlinkResult.Error().Code == EPortoError::VolumeNotLinked) {
                    Porto_->UnlinkVolume(volume, TPortoContainerName::NoEscape("***"), "***", false).GetValueSync();
                }
            }
        }

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
