#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoCleanLinkedVolumesNode;
using TPortoCleanLinkedVolumesNodePtr = TSimpleSharedPtr<TPortoCleanLinkedVolumesNode>;

class TPortoCleanLinkedVolumesNode : public TPortoBasicNode<TExpected<TVector<TString>, TPortoError>> {
public:
    TPortoCleanLinkedVolumesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& path
        , const TPortoContainerName& container
    )
        : TPortoBasicNode(descriptor, porto)
        , Path_(path.EndsWith("/") ? path : path + "/")
        , Container_(container)
    {
        Y_ENSURE(Path_.StartsWith("/"), "path must be absolute");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TVector<TString>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TVector<TString>, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_CLEAN_LINKED_VOLUMES;

private:
    const TString Path_;
    const TPortoContainerName Container_;
};

} // namespace NInfra::NPodAgent

