#include "porto_clean_old_containers_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoCleanOldContainersNode::GetType() const {
    return TPortoCleanOldContainersNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> TPortoCleanOldContainersNode::PortoCall(TTickContextPtr /*context*/) {
    TVector<EPortoContainerProperty> properties{EPortoContainerProperty::Private};
    return Porto_->Get({ContainerLookupMask_}, properties);
}

TTickResult TPortoCleanOldContainersNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>& result) {
    if (result) {
        for (const auto& [containerId, containerProperties] : result.Success()) {
            if (auto result = PathHolder_->ExtractWorkloadIdFromContainer(containerId)) {
                // not wait for Destroy to complete, so we don’t check Success
                if (result == WorkloadId_ && TreeHash_ != UnpackContainerPrivate(containerProperties.at(EPortoContainerProperty::Private).value()).TreeHash_) {
                    Porto_->Destroy(containerId);
                }
            }
        }
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
