#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/private_util.h>

#include <infra/pod_agent/libs/path_util/path_holder.h>

namespace NInfra::NPodAgent {

class TPortoCleanOldContainersNode;
using TPortoCleanOldContainersNodePtr = TSimpleSharedPtr<TPortoCleanOldContainersNode>;

class TPortoCleanOldContainersNode : public TPortoBasicNode<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>> {
public:
    TPortoCleanOldContainersNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TPathHolderPtr pathHolder
        , const TString& treehash
        , const TString& workloadId
        , const TPortoContainerName& containerLookupMask
    )
        : TPortoBasicNode(descriptor, porto)
        , PathHolder_(pathHolder)
        , TreeHash_(treehash)
        , WorkloadId_(workloadId)
        , ContainerLookupMask_(containerLookupMask)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>& result) override final;


public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_CLEAN_OLD_CONTAINERS;

private:
    const TPathHolderPtr PathHolder_;
    const TString TreeHash_;
    const TString WorkloadId_;
    const TPortoContainerName ContainerLookupMask_;
};

} // namespace NInfra::NPodAgent

