#include "porto_clean_old_containers_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/porto_client/mock_client.h>
#include <infra/pod_agent/libs/porto_client/test_functions.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NPortoTest::NTestPortoCleanOldContainersNode {

Y_UNIT_TEST_SUITE(PortoCleanOldContainersNodeSuite) {

static TLogger logger({});

TPortoCleanOldContainersNodePtr CreateNode(
    TPortoClientPtr porto
    , TPathHolderPtr pathHolder
    , const TString& treehash
    , const TString& workloadId
    , const TPortoContainerName& containerLookupMask
) {
    return new TPortoCleanOldContainersNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , new TAsyncPortoClient(porto, new TFakeThreadPool())
        , pathHolder
        , treehash
        , workloadId
        , containerLookupMask
    );
}

Y_UNIT_TEST(TestRemoveOldContainer) {
    struct TMyPortoClient : public TMockPortoClient {
        TMyPortoClient(const TSet<TPortoContainerName>& containers, const TString& treehash)
            : ActiveContainers_(containers)
            , TreeHash_(treehash)
        {}

        TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError> Get(
            const TVector<TPortoContainerName>& names
            , const TVector<EPortoContainerProperty>& props
        ) override {
            ++GetCalls_;

            Names_ = names;
            Props_ = props;

            TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>> result;
            for (const auto& name : ActiveContainers_) {
                result[name] = TMap<EPortoContainerProperty, TPortoGetResponse>();
                result[name][EPortoContainerProperty::Private] = CreateTPortoGetResponse(PackContainerPrivate({CP_READY, TreeHash_}), 0, "");
            }
            return result;
        }

        TExpected<void, TPortoError> Destroy(const TPortoContainerName& name) override {
            ++DestroyCalls_;

            ActiveContainers_.erase(name);
            return TExpected<void, TPortoError>::DefaultSuccess();
        }

        size_t GetCalls_ = 0;
        size_t DestroyCalls_ = 0;
        TSet<TPortoContainerName> ActiveContainers_;
        TString TreeHash_;
        TVector<TPortoContainerName> Names_;
        TVector<EPortoContainerProperty> Props_;
    };

    auto test = [](const TSet<TPortoContainerName>& containers, size_t badContainers, TString treehash) {
        TPortoClientPtr porto = new TMyPortoClient(containers, treehash);

        auto node = CreateNode(porto, new TPathHolder("", {{"", ""}}, {{"", ""}}, "", "", "", "", "", ""), "tree_hash", "MyWorkload", TPortoContainerName("ContainerLookupMask"));
        auto result = node->Tick(MockTickContext(logger));

        UNIT_ASSERT_EQUAL_C(ENodeStatus::SUCCESS, result.Success().Status, result.Success().Message);
        UNIT_ASSERT_EQUAL_C(1, ((TMyPortoClient*)porto.Get())->GetCalls_, ((TMyPortoClient*)porto.Get())->GetCalls_);
        UNIT_ASSERT_EQUAL_C(badContainers, ((TMyPortoClient*)porto.Get())->DestroyCalls_, ((TMyPortoClient*)porto.Get())->DestroyCalls_);
        UNIT_ASSERT_EQUAL(
            ((TMyPortoClient*)porto.Get())->Names_
            , TVector<TPortoContainerName>({TPortoContainerName("ContainerLookupMask")})
        );
        UNIT_ASSERT_EQUAL(
            ((TMyPortoClient*)porto.Get())->Props_
            , TVector<EPortoContainerProperty>({EPortoContainerProperty::Private})
        );
        UNIT_ASSERT_EQUAL_C(containers.size() - badContainers, ((TMyPortoClient*)porto.Get())->ActiveContainers_.size(), ((TMyPortoClient*)porto.Get())->ActiveContainers_.size());
    };

    TSet<TPortoContainerName> testResponse;
    testResponse.insert(TPortoContainerName::NoEscape("box_MyBox/workload_MyWorkload_init1"));

    // test delete all containers
    test(testResponse, testResponse.size(), "old_hash");

    testResponse.clear();
    testResponse.insert(TPortoContainerName::NoEscape("box_MyBox/workload_OutsiderWorkload_init1"));

    // test outsider container
    test(testResponse, 0, "old_hash");

    testResponse.clear();
    testResponse.insert(TPortoContainerName::NoEscape("box_MyBox/workload_MyWorkload_init1"));
    // test same treehash
    test(testResponse, 0, "tree_hash");
}

}

} // namespace NInfra::NPodAgent::NPortoTest::NTestPortoCleanOldContainersNode
