#include "porto_container_exists_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoContainerExistsNode::GetType() const {
    return TPortoContainerExistsNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<int, TPortoError>>, TTickResult> TPortoContainerExistsNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->IsContainerExists(Name_);
}

TTickResult TPortoContainerExistsNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<int, TPortoError>& result) {
    if (!result) {
        return TNodeError{ToString(result.Error())};
    }
    return (result.Success())
        ? TNodeSuccess(ENodeStatus::SUCCESS)
        : TNodeSuccess(ENodeStatus::FAILURE, "Container not found");
}

} // namespace NInfra::NPodAgent
