#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoContainerExistsNode;
using TPortoContainerExistsNodePtr = TSimpleSharedPtr<TPortoContainerExistsNode>;

class TPortoContainerExistsNode : public TPortoBasicNode<TExpected<int, TPortoError>> {
public:
    TPortoContainerExistsNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TPortoContainerName& name
    )
        : TPortoBasicNode(descriptor, porto)
        , Name_(name)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<int, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<int, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_CONTAINER_EXISTS;

private:
    const TPortoContainerName Name_;
};

} // namespace NInfra::NPodAgent
