#include "porto_container_private_matches_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoContainerPrivateMatchesNode::GetType() const {
    return TPortoContainerPrivateMatchesNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoContainerPrivateMatchesNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(Name_, EPortoContainerProperty::Private);
}

TTickResult TPortoContainerPrivateMatchesNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) {
    if (!result) {
        if (result.Error().Code == EPortoError::ContainerDoesNotExist) {
            return TNodeSuccess{ENodeStatus::FAILURE, TStringBuilder() << "container " << TString(Name_) << " does not exist"};
        }
        return TNodeError{ToString(result.Error())};
    }

    TContainerPrivateUnpacked  unpacked = UnpackContainerPrivate(result.Success());
    if (unpacked.TreeHash_ != TreeHash_) {
        return TNodeSuccess{ENodeStatus::FAILURE,
            TStringBuilder() << "container '" << TString(Name_) << "' has incorrect tree hash: '" << unpacked.TreeHash_ << "' instead of '" << TreeHash_ << "'"};
    }

    return (unpacked.Value_ == Value_)
           ? TNodeSuccess(ENodeStatus::SUCCESS)
           : TNodeSuccess(ENodeStatus::FAILURE,
                          TStringBuilder() << "expected '" << Value_ << "' got '" << unpacked.Value_ << "'");
}

} // namespace NInfra::NPodAgent
