#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/private_util.h>

namespace NInfra::NPodAgent {

class TPortoContainerPrivateMatchesNode;
using TPortoContainerPrivateMatchesNodePtr = TSimpleSharedPtr<TPortoContainerPrivateMatchesNode>;

class TPortoContainerPrivateMatchesNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoContainerPrivateMatchesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TPortoContainerName& name
        , const TString& treeHash
        , EContainerPrivate value
    )
        : TPortoBasicNode(descriptor, porto)
        , Name_(name)
        , TreeHash_(treeHash)
        , Value_(value)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_CONTAINER_PRIVATE_MATCHES;

private:
    const TPortoContainerName Name_;
    const TString TreeHash_;
    const EContainerPrivate Value_;
};

} // namespace NInfra::NPodAgent
