#include "porto_container_property_matches_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoContainerPropertyMatchesNode::GetType() const {
    return TPortoContainerPropertyMatchesNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoContainerPropertyMatchesNode::PortoCall(TTickContextPtr /*context*/) {
    if (Property_ == EPortoContainerProperty::StdErr) {
        return Porto_->GetStderr(Name_, -1, TPortoContainerPropertyMatchesNode::STREAM_LENGTH);
    } else if (Property_ == EPortoContainerProperty::StdOut) {
        return Porto_->GetStdout(Name_, -1, TPortoContainerPropertyMatchesNode::STREAM_LENGTH);
    } else {
        return Porto_->GetProperty(Name_, Property_);
    }
}

TTickResult TPortoContainerPropertyMatchesNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) {
    if (!result) {
        return TNodeError{ToString(result.Error())};
    }

    TString value = result.Success();
    return  (value == Value_)
        ? TNodeSuccess(ENodeStatus::SUCCESS)
        : TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "expected '" << Value_ << "' got '" << value << "'");
}

} // namespace NInfra::NPodAgent
