#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoContainerPropertyMatchesNode;
using TPortoContainerPropertyMatchesNodePtr = TSimpleSharedPtr<TPortoContainerPropertyMatchesNode>;

class TPortoContainerPropertyMatchesNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoContainerPropertyMatchesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TPortoContainerName& name
        , EPortoContainerProperty property
        , const TString& value
    )
        : TPortoBasicNode(descriptor, porto)
        , Name_(name)
        , Property_(property)
        , Value_(value)
    {
        Y_ENSURE(Property_ != EPortoContainerProperty::Private,
            "Use TPortoContainerPrivateMatchesNode or TPortoContainerTreeHashMatchesNode for EPortoContainerProperty::Private");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_CONTAINER_PROPERTY_MATCHES;

    static constexpr const i32 STREAM_LENGTH = (1 << 12); // 4 Kb

private:
    const TPortoContainerName Name_;
    const EPortoContainerProperty Property_;
    const TString Value_;
};

} // namespace NInfra::NPodAgent
