#include "porto_container_time_expired_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoContainerTimeExpiredNode::GetType() const {
    return TPortoContainerTimeExpiredNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoContainerTimeExpiredNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(Name_, InitialTime_);
}

TTickResult TPortoContainerTimeExpiredNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) {
    if (!result) {
        return TNodeError{ToString(result.Error())};
    }
    try {
        switch (TimeType_) {
            case TPortoContainerTimeExpiredNode::ETimeType::UNIX_TIMESTAMP:
                return ProcessUnixTimestamp(result);
            case TPortoContainerTimeExpiredNode::ETimeType::ABSOLUTE_VALUE:
                return ProcessAbsoluteValue(result);
        }
    } catch (TFromStringException& e) {
        return TNodeError{
            TStringBuilder() << "Could not parse DateTime from:" << "'" << result.Success() << "'"
        };
    }
}

TTickResult TPortoContainerTimeExpiredNode::ProcessUnixTimestamp(TExpected<TString, TPortoError>& result) {
    time_t startTime = FromString<time_t>(result.Success());
    TInstant expireTime = TInstant::Seconds(startTime) + ExpireDuration_;
    return (expireTime <= Now())
        ? TNodeSuccess(ENodeStatus::SUCCESS)
        : TNodeSuccess(
            ENodeStatus::FAILURE
            , TStringBuilder() << "not expired: " << TInstant::Seconds(startTime)
        );
}

TTickResult TPortoContainerTimeExpiredNode::ProcessAbsoluteValue(TExpected<TString, TPortoError>& result) {
    TDuration currentTime = TDuration::Seconds(FromString<ui64>(result.Success()));
    // "<=" is important
    // Due to rounding to seconds we will always wait 1 second before expired if we place "<" here
    return (ExpireDuration_ <= currentTime)
        ? TNodeSuccess(ENodeStatus::SUCCESS)
        : TNodeSuccess(
            ENodeStatus::FAILURE
            , TStringBuilder() << "not expired: " << currentTime
        );
}

} // namespace NInfra::NPodAgent
