#include "porto_container_tree_hash_matches_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoContainerTreeHashMatchesNode::GetType() const {
    return TPortoContainerTreeHashMatchesNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoContainerTreeHashMatchesNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(Name_, EPortoContainerProperty::Private);
}

TTickResult TPortoContainerTreeHashMatchesNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) {
    if (!result) {
        return TNodeError{ToString(result.Error())};
    }

    TContainerPrivateUnpacked unpacked = UnpackContainerPrivate(result.Success());
    if (unpacked.Value_ == CP_EXTRACTION_FAILURE) {
        return TNodeSuccess{ENodeStatus::FAILURE,
            TStringBuilder() << "private property of container " << TString(Name_) << " has incorrect form: " << result.Success()
        };
    }

    return (unpacked.TreeHash_ == Value_)
           ? TNodeSuccess(ENodeStatus::SUCCESS)
           : TNodeSuccess(ENodeStatus::FAILURE,
                          TStringBuilder() << "expected '" << Value_ << "' got '" << unpacked.TreeHash_ << "'");
}

} // namespace NInfra::NPodAgent
