#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/private_util.h>

namespace NInfra::NPodAgent {

class TPortoContainerTreeHashMatchesNode;
using TPortoContainerTreeHashMatchesNodePtr = TSimpleSharedPtr<TPortoContainerTreeHashMatchesNode>;

class TPortoContainerTreeHashMatchesNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoContainerTreeHashMatchesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TPortoContainerName& name
        , const TString& value
    )
        : TPortoBasicNode(descriptor, porto)
        , Name_(name)
        , Value_(value)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_CONTAINER_TREE_HASH_MATCHES;

private:
    const TPortoContainerName Name_;
    const TString Value_;
};

} // namespace NInfra::NPodAgent
