#include "porto_container_tree_hash_matches_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/porto_client/mock_client.h>

#include <infra/libs/logger/logger.h>
#include <infra/libs/logger/log_frame.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NTestPortoContainerTreeHashMatchesNode {

Y_UNIT_TEST_SUITE(TPortoContainerTreeHashMatchesNodeSuite) {

static TLogger logger({});

TPortoContainerTreeHashMatchesNodePtr CreateNode(
    TAsyncPortoClientPtr porto
    , const TPortoContainerName& name
    , const TString& value
) {
    return new TPortoContainerTreeHashMatchesNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , porto
        , name
        , value
    );
}

Y_UNIT_TEST(TestPrivateMatches) {
    struct TMyPortoClient : public TMockPortoClient {
        TExpected<TString, TPortoError> GetProperty(const TPortoContainerName& name, EPortoContainerProperty property, int /*flags*/) override {
            Name_ = name;
            Property_ = property;

            return TString(":value");
        }

        TPortoContainerName Name_ = TString("");
        EPortoContainerProperty Property_;
    };

    TPortoClientPtr myPorto = new TMyPortoClient();
    TAsyncPortoClientPtr porto = new TAsyncPortoClient(myPorto, new TFakeThreadPool());

    TPortoContainerName name = {"container_0"};

    auto creator = CreateNode(porto, name, "value");
    auto result = creator->Tick(MockTickContext(logger));

    UNIT_ASSERT_EQUAL(ENodeStatus::SUCCESS, result.Success().Status);
    UNIT_ASSERT_EQUAL(name, ((TMyPortoClient*)myPorto.Get())->Name_);
    UNIT_ASSERT_EQUAL(EPortoContainerProperty::Private, ((TMyPortoClient*)myPorto.Get())->Property_);
}

Y_UNIT_TEST(TestPrivateNotMatches) {
    struct TMyPortoClient : public TMockPortoClient {
        TExpected<TString, TPortoError> GetProperty(const TPortoContainerName& name, EPortoContainerProperty property, int /*flags*/) override {
            Name_ = name;
            Property_ = property;

            return TString(":other value");
        }

        TPortoContainerName Name_ = TString("");
        EPortoContainerProperty Property_;
    };

    TPortoClientPtr myPorto = new TMyPortoClient();
    TAsyncPortoClientPtr porto = new TAsyncPortoClient(myPorto, new TFakeThreadPool());

    TPortoContainerName name = {"container_0"};

    auto creator = CreateNode(porto, name, "value");
    auto result = creator->Tick(MockTickContext(logger));

    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
    UNIT_ASSERT_EQUAL(name, ((TMyPortoClient*)myPorto.Get())->Name_);
    UNIT_ASSERT_EQUAL(EPortoContainerProperty::Private, ((TMyPortoClient*)myPorto.Get())->Property_);
}

Y_UNIT_TEST(TestPrivateWrongFormat) {
    struct TMyPortoClient : public TMockPortoClient {
        TExpected<TString, TPortoError> GetProperty(const TPortoContainerName& name, EPortoContainerProperty property, int /*flags*/) override {
            Name_ = name;
            Property_ = property;

            return TString("value");
        }

        TPortoContainerName Name_ = TString("");
        EPortoContainerProperty Property_;
    };

    TPortoClientPtr myPorto = new TMyPortoClient();
    TAsyncPortoClientPtr porto = new TAsyncPortoClient(myPorto, new TFakeThreadPool());

    TPortoContainerName name = {"container_0"};

    auto creator = CreateNode(porto, name, "value");
    auto result = creator->Tick(MockTickContext(logger));

    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
    UNIT_ASSERT_EQUAL(name, ((TMyPortoClient*)myPorto.Get())->Name_);
    UNIT_ASSERT_EQUAL(EPortoContainerProperty::Private, ((TMyPortoClient*)myPorto.Get())->Property_);
}

}

} // namespace NInfra::NPodAgent::NTestPortoContainerTreeHashMatchesNode
