#include "porto_create_recursive_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoCreateRecursiveNode::GetType() const {
    return TPortoCreateRecursiveNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoCreateRecursiveNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->CreateRecursive(ContainerName_);
}

TTickResult TPortoCreateRecursiveNode::ProcessPortoResultError(TTickContextPtr context, TPortoError& result) {
    if (result.Code == EPortoError::ContainerAlreadyExists) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        // Process error
        TPortoBasicContainerNode<void>::ProcessPortoResultError(context, result);

        // If this node fails, we need to return FAILURE (not error)
        // because we need to feedback state
        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result));
    }
}

} // namespace NInfra::NPodAgent
