#include "porto_create_volume_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoCreateVolumeNode::GetType() const {
    return TPortoCreateVolumeNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoCreateVolumeNode::PortoCall(TTickContextPtr /*context*/) {
    TVector<TPortoVolumeShare> volumeShares;
    for(size_t resourceNum = 0; resourceNum < StaticResourcePaths_.size(); ++resourceNum) {
        volumeShares.push_back({ StaticResourcePaths_.at(resourceNum), StaticResourceOrigPaths_.at(resourceNum), false });
    }

    return Porto_->CreateVolume(
        Path_
        , Storage_
        , Place_
        , Layers_
        , QuotaBytes_
        , Private_
        , Backend_
        , TPortoContainerName::NoEscape(".")
        , volumeShares
        , ReadOnly_
    );
}

TTickResult TPortoCreateVolumeNode::ProcessPortoResult(TTickContextPtr /* context */, TExpected<TString, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, ToString(result.Error()));
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);
        if (result.Error().Code == EPortoError::Busy
            // InvalidPath is thrown in case directory not exists or volume overlaps with other volume
            || result.Error().Code == EPortoError::InvalidPath
            // InvalidValue is thrown in case private value is too long
            || result.Error().Code == EPortoError::InvalidValue
            || result.Error().Code == EPortoError::VolumeAlreadyExists
            // mkdirat error is interpreted as Unknown, we can get the real reason only from message
            || (result.Error().Code == EPortoError::Unknown && result.Error().Message.Contains("Disk quota exceeded"))
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
