#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

namespace NInfra::NPodAgent {

class TPortoCreateVolumeNode;
using TPortoCreateVolumeNodePtr = TSimpleSharedPtr<TPortoCreateVolumeNode>;

class TPortoCreateVolumeNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoCreateVolumeNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
        , const TString& path
        , const TString& storage
        , const TString& place
        , const TVector<TString> layers
        , const TVector<TString> staticResourceOrigPaths
        , const TVector<TString> staticResourcePaths
        , size_t quotaBytes
        , const TString& privateValue
        , const EPortoVolumeBackend backend
        , bool readOnly
    )
        : TPortoBasicNode(descriptor, porto)
        , StatusRepositoryCommon_(statusRepositoryCommon)
        , ObjectIdOrHash_(objectIdOrHash)
        , Path_(path)
        , Storage_(storage)
        , Place_(place)
        , Layers_(layers)
        , StaticResourceOrigPaths_(staticResourceOrigPaths)
        , StaticResourcePaths_(staticResourcePaths)
        , QuotaBytes_(quotaBytes)
        , Private_(privateValue)
        , Backend_(backend)
        , ReadOnly_(readOnly)
    {
        Y_ENSURE(StaticResourceOrigPaths_.size() == StaticResourcePaths_.size(), "TPortoCreateVolumeNode static resource paths size should be equal to static resource original paths size");
        Y_ENSURE(StatusRepositoryCommon_, "StatusRepositoryCommon not defined for TPortoCreateVolumeNode");
        Y_ENSURE(dynamic_cast<TWorkloadStatusRepository*>(statusRepositoryCommon.Get()) == nullptr, "You can't create volume in workload tree");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_CREATE_VOLUME;

private:
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
    const TString ObjectIdOrHash_;

    const TString Path_;
    const TString Storage_;
    const TString Place_;
    const TVector<TString> Layers_;
    const TVector<TString> StaticResourceOrigPaths_;
    const TVector<TString> StaticResourcePaths_;
    const size_t QuotaBytes_;
    const TString Private_;
    const EPortoVolumeBackend Backend_;
    const bool ReadOnly_;
};

} // namespace NInfra::NPodAgent
