#include "porto_destroy_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoDestroyNode::GetType() const {
    return TPortoDestroyNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoDestroyNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->Destroy(Name_);
}

TTickResult TPortoDestroyNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<void, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS, "Container destroyed");
    } else {
        if (result.Error().Code == EPortoError::ContainerDoesNotExist) {
            return TNodeSuccess(ENodeStatus::SUCCESS, "Already destroyed");
        }

        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
