#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoGetAndCheckVolumePropertiesNode;
using TPortoGetAndCheckVolumePropertiesNodePtr = TSimpleSharedPtr<TPortoGetAndCheckVolumePropertiesNode>;

class TPortoGetAndCheckVolumePropertiesNode : public TPortoBasicNode<TExpected<TVector<TPortoVolume>, TPortoError>> {
public:
    TPortoGetAndCheckVolumePropertiesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& path
        , const TMap<EPortoVolumeProperty, TString>& properties // TMap (not Hash) for stable iteration
    )
        : TPortoBasicNode(descriptor, porto)
        , Path_(path)
        , Properties_(properties)
    {
        for (const auto& property : properties) {
            Y_ENSURE(
                IMPLEMENTED_PROPERTIES.contains(property.first),
                TStringBuilder()
                    << "property '"
                    << ToString(property.first)
                    << "' is not implemented"
            );
        }
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TVector<TPortoVolume>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TVector<TPortoVolume>, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_GET_AND_CHECK_VOLUME_PROPERTIES;

private:
    inline static const THashSet<EPortoVolumeProperty> IMPLEMENTED_PROPERTIES = {
        EPortoVolumeProperty::Private
        , EPortoVolumeProperty::Storage
        , EPortoVolumeProperty::State
        , EPortoVolumeProperty::ReadOnly
    };

    const TString Path_;
    const TMap<EPortoVolumeProperty, TString> Properties_;
};

} // namespace NInfra::NPodAgent
