#include "porto_get_container_state_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoGetContainerStateNode::GetType() const {
    return TPortoGetContainerStateNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoGetContainerStateNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(Name_, EPortoContainerProperty::State);
}

TTickResult TPortoGetContainerStateNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS, result.Success());
    } else {
        if (result.Error().Code == EPortoError::Busy
            || result.Error().Code == EPortoError::ContainerDoesNotExist
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
