#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoGetContainerStateNode;
using TPortoGetContainerStateNodePtr = TSimpleSharedPtr<TPortoGetContainerStateNode>;

class TPortoGetContainerStateNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoGetContainerStateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TPortoContainerName& name
    )
        : TPortoBasicNode(descriptor, porto)
        , Name_(name)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_GET_CONTAINER_STATE;

private:
    const TPortoContainerName Name_;
};

} // namespace NInfra::NPodAgent
