#include "porto_get_download_progress_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoGetDownloadProgressNode::GetType() const {
    return TPortoGetDownloadProgressNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoGetDownloadProgressNode::PortoCall(TTickContextPtr /* context */) {
    return Porto_->GetStderr(ContainerName_, -1, -1, 0);
}

TTickResult TPortoGetDownloadProgressNode::ProcessPortoResult(TTickContextPtr /* context */, TExpected<TString, TPortoError>& result) {
    if (result) {
        size_t position = result.Success().find_last_of('%');
        ui32 percent = 0;
        if (position != TString::npos && NeedCheckDownloadProgress_) {
            for (
                i64 currentPosition = (i64)position - 1, multiplier = 1;
                currentPosition >= 0 && result.Success()[currentPosition] >= '0' && result.Success()[currentPosition] <= '9' && multiplier < 1000;
                --currentPosition, multiplier *= 10
            ) {
                percent += (result.Success()[currentPosition] - '0') * multiplier;
            }
            if (percent > 100) {
                percent = 0;
            }
        }

        ContainerStatusRepository_->UpdateObjectDownloadProgress(ObjectIdOrHash_, percent);
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
